/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.OpCode;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;

class ConvertOp
extends OpCode {
    private int dataType = -1;
    private int dimensions = 0;
    private boolean isConst = false;
    private SimpleDateFormat defaultDateFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public ConvertOp(int opCode, int type, boolean theIsConst, int dim) {
        super(opCode);
        this.dataType = type;
        this.dimensions = dim;
        this.isConst = theIsConst;
    }

    public String toString() {
        return super.toString() + "(" + "data type=" + String.valueOf(this.dataType) + ", dimensions=" + String.valueOf(this.dimensions) + ")";
    }

    public int dispatch(Stack runStack, IFieldCollection mainFields, IFieldCollection alternateFields, Hashtable envData) throws VWException {
        switch (this.opCode) {
            case 51: {
                this.doConvertFunc(runStack);
                break;
            }
            case 9: {
                this.doIsValidFunc(runStack);
                break;
            }
            case 91: {
                this.doEnvFieldFunc(runStack);
                break;
            }
            case 92: {
                this.doSystemEnvFieldFunc(runStack);
                break;
            }
            case 93: {
                this.doUserEnvFieldFunc(runStack);
                break;
            }
            default: {
                throw new VWException("vw.base.ExpressionExecution.BadOpCode", "***Opcode ({0}) not implemented.", this.toString());
            }
        }
        return -1;
    }

    private void doConvertFunc(Stack runStack) throws VWException {
        Object val = runStack.pop();
        if (this.dimensions == 0) {
            runStack.push(this.convertValue(val, this.dataType, this.isConst));
        } else {
            if (this.dimensions != 1) {
                throw new VWException("vw.base.ExpressionExecution.InvalidArrayDimension", "Array dimension {0} is greater than 1.", String.valueOf(this.dimensions));
            }
            if (!val.getClass().isArray()) {
                throw new VWException("vw.base.ExpressionExecution.ArrayDimensionButNotArray", "Dimensions is 1, but value is not an array");
            }
            int length = ((Object[])val).length;
            Object[] newArray = this.makeArray(this.dataType, length);
            for (int i = 0; i < length; ++i) {
                newArray[i] = this.convertValue(((Object[])val)[i], this.dataType, this.isConst);
            }
            runStack.push(newArray);
        }
    }

    private void doIsValidFunc(Stack runStack) throws VWException {
        Object val = runStack.pop();
        if (this.dimensions == 0) {
            try {
                this.convertValue(val, this.dataType, this.isConst);
                runStack.push(new Boolean(true));
            }
            catch (Exception e) {
                runStack.push(new Boolean(false));
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.IsValidArrayNotSupported", "Dimensions is 1, but is_valid function supports simple types only, not arrays");
        }
    }

    private void doEnvFieldFunc(Stack runStack) {
        System.out.print("*** EnvFieldFunc not implemented.\n");
    }

    private void doSystemEnvFieldFunc(Stack runStack) {
        System.out.print("*** SystemEnvFieldFunc not implemented.\n");
    }

    private void doUserEnvFieldFunc(Stack runStack) {
        System.out.print("*** UserEnvFieldFunc not implemented.\n");
    }

    private Object convertValue(Object val, int datatype, boolean isConst) throws VWException {
        Object newVal = null;
        switch (datatype) {
            case 1: {
                if (val instanceof String) {
                    newVal = new Integer(new Double(Double.parseDouble((String)val)).intValue());
                    break;
                }
                if (val instanceof Integer) {
                    newVal = val;
                    break;
                }
                if (val instanceof Double) {
                    newVal = new Integer(((Double)val).intValue());
                    break;
                }
                if (val instanceof Boolean) {
                    if (((Boolean)val).booleanValue()) {
                        newVal = new Integer(1);
                        break;
                    }
                    newVal = new Integer(0);
                    break;
                }
                if (val instanceof Date) {
                    newVal = new Integer(new Long(((Date)val).getTime() / 1000L).intValue());
                    break;
                }
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeConvertFrom", "The data type for the conversion is invalid");
            }
            case 2: 
            case 32: 
            case 64: {
                if (val instanceof Date) {
                    newVal = this.defaultDateFormatter.format((Date)val);
                    break;
                }
                newVal = val.toString();
                break;
            }
            case 4: {
                if (val instanceof String) {
                    if (((String)val).toString().compareToIgnoreCase("true") == 0) {
                        newVal = new Boolean(true);
                        break;
                    }
                    if (((String)val).toString().compareToIgnoreCase("false") == 0) {
                        newVal = new Boolean(false);
                        break;
                    }
                    throw new VWException("vw.base.ExpressionExecution.InvalidConvertionValue", "Invalid conversion value");
                }
                if (val instanceof Integer) {
                    if ((Integer)val == 1) {
                        newVal = new Boolean(true);
                        break;
                    }
                    if ((Integer)val == 0) {
                        newVal = new Boolean(false);
                        break;
                    }
                    throw new VWException("vw.base.ExpressionExecution.InvalidConvertionValue", "Invalid conversion value");
                }
                if (val instanceof Double) {
                    if ((Double)val == 1.0) {
                        newVal = new Boolean(true);
                        break;
                    }
                    if ((Double)val == 0.0) {
                        newVal = new Boolean(false);
                        break;
                    }
                    throw new VWException("vw.base.ExpressionExecution.InvalidConvertionValue", "Invalid conversion value");
                }
                if (val instanceof Boolean) {
                    newVal = val;
                    break;
                }
                if (val instanceof Date) {
                    throw new VWException("vw.base.ExpressionExecution.InvalidConvertionValue", "Invalid conversion value");
                }
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeConvertFrom", "The data type for the conversion is invalid");
            }
            case 8: {
                if (val instanceof String) {
                    newVal = new Double(Double.parseDouble((String)val));
                    break;
                }
                if (val instanceof Integer) {
                    newVal = new Double(((Integer)val).doubleValue());
                    break;
                }
                if (val instanceof Double) {
                    newVal = val;
                    break;
                }
                if (val instanceof Boolean) {
                    if (((Boolean)val).booleanValue()) {
                        newVal = new Double(1.0);
                        break;
                    }
                    newVal = new Double(0.0);
                    break;
                }
                if (val instanceof Date) {
                    newVal = new Double(new Long(((Date)val).getTime() / 1000L).intValue());
                    break;
                }
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeConvertFrom", "The data type for the conversion is invalid");
            }
            case 16: {
                if (val instanceof String) {
                    newVal = ((String)val).equals("") ? new Date(new Long("-2000000000000")) : this.defaultDateFormatter.parse((String)val, new ParsePosition(0));
                    if (newVal != null) break;
                    throw new VWException("vw.base.ExpressionExecution.InvalidDateConvertion", "Invalid date conversion");
                }
                if (val instanceof Integer) {
                    newVal = new Date(((Integer)val).longValue());
                    break;
                }
                if (val instanceof Double) {
                    newVal = new Date(((Double)val).longValue());
                    break;
                }
                if (val instanceof Boolean) {
                    throw new VWException("vw.base.ExpressionExecution.InvalidConvertionValue", "Invalid conversion value");
                }
                if (val instanceof Date) {
                    newVal = val;
                    break;
                }
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeConvertFrom", "The data type for the conversion is invalid");
            }
            default: {
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeConvertTo", "The data type for the conversion is invalid");
            }
        }
        return newVal;
    }

    private Object[] makeArray(int type, int length) throws VWException {
        Object[] newArray = null;
        switch (this.dataType) {
            case 1: {
                newArray = new Integer[length];
                break;
            }
            case 2: 
            case 32: 
            case 64: {
                newArray = new String[length];
                break;
            }
            case 4: {
                newArray = new Boolean[length];
                break;
            }
            case 8: {
                newArray = new Double[length];
                break;
            }
            case 16: {
                newArray = new Date[length];
                break;
            }
            default: {
                throw new VWException("vw.base.ExpressionExecution.InvalidDataTypeForArray", "Invalid data type for new array");
            }
        }
        return newArray;
    }
}

